package user_interface;
import db_context.MyExceptions;
import row_data_gateway.*;
import complex_operations.*;
import row_data_gateway.Package;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.Timestamp;

public class MenuTransport extends Menu {
    @Override
    public void print() {
        System.out.println("************************************");
        System.out.println("* 1. create transport              *");
        System.out.println("* 2. create transport segment      *");
        System.out.println("* 3. set arr and dep time          *");
        System.out.println("* 4. show planned package route    *");
        System.out.println("* 5. add accident record           *");
        System.out.println("* 6. back to main menu             *");
        System.out.println("************************************");
    }

    @Override
    public void handle(String option) {
        try {
            switch (option) {
                case "1":  createTransport(); break;
                case "2":  createSegment(); break;
                case "3":  setTransportArrDepTime(); break;
                case "4":  getPlannedRoute(); break;
                case "5":  addAccidentRecord(); break;
                case "6":   exit(); break;
                default:    System.out.println("Unknown option"); break;
            }
        } catch(Exception e) {
            //throw new RuntimeException(e);
            if(e.getClass().toString().equals("class java.lang.NumberFormatException")) System.out.println("Wrong input");
            else if(e.getClass().equals("class java.lang.IllegalArgumentException")) System.out.println("Wrong input");
            else System.out.println("something went wrong\nmessage: " + e.getMessage());
        }
    }

    private void createTransport() throws Exception{
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Enter package id");

        Package p = PackageFinder.getInstance().findById(Integer.parseInt(br.readLine()));
        p.setDelivery_price(OtherOperations.getInstance().countDeliveryPrice(p.getId()));
        if(!p.getStatus().equals("new")) throw new MyExceptions.LogicException("This package was already scheduled for transport");
        if(p.getDelivery_price() == null) throw new MyExceptions.LogicException("This package is empty");

        p.setStatus("ready");
        p.setDelivery_price(OtherOperations.getInstance().countDeliveryPrice(p.getId()));
        p.update();

        Transport t = new Transport();
        t.setPackage_id(p.getId());
        t.setStarting_loc_id(OtherOperations.getInstance().findCustomerLocation(p.getSender_id()));
        t.setDestination_loc_id(OtherOperations.getInstance().findCustomerLocation(p.getRecipient_id()));
        t.setRoute(PathFinder.getInstance().recursive_sql(t.getStarting_loc_id(), t.getDestination_loc_id()));
        t.insert();

        System.out.println("new transport has been made, id:" + t.getId());
    }

    private void getPlannedRoute() throws Exception{
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Enter package id");

        Transport transport = TransportFinder.getInstance().findByPackageId(Integer.parseInt(br.readLine()));
        System.out.println(OtherOperations.getInstance().translateRoute(transport.getRoute()));
    }

    private void createSegment() throws Exception{
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        Segment segment = new Segment();

        System.out.println("Enter transport id");
        Transport transport = TransportFinder.getInstance().findById(Integer.parseInt(br.readLine()));
        segment.setTransport_id(transport.getId());

        System.out.println("Enter connection id");
        int var = Integer.parseInt(br.readLine());
        if(var < 1 || var > 168) throw new MyExceptions.NotSuchIdException("Not such connection");
        segment.setConnection_id(var);

        System.out.println("Enter time: (YYYY-MM-DD HH:MI:SS)");
        segment.setTime(Timestamp.valueOf(br.readLine()));
        segment.insert();
        System.out.println("new segment has been added, id: " + segment.getId());

    }

    private void setTransportArrDepTime() throws Exception{
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Enter transport id");

        Transport transport = TransportFinder.getInstance().findById(Integer.parseInt(br.readLine()));
        System.out.println("Enter Departure time: (YYYY-MM-DD HH:MI:SS)");
        transport.setDeparture_time(Timestamp.valueOf(br.readLine()));
        System.out.println("Enter arrival time: (YYYY-MM-DD HH:MI:SS)");
        transport.setArrival_time(Timestamp.valueOf(br.readLine()));
        transport.update();
    }

    private void addAccidentRecord() throws Exception{
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Enter segment id");

        Segment segment = SegmentFinder.getInstance().findById(Integer.parseInt(br.readLine()));
        System.out.println("Enter damage in %: ");
        int var = Integer.parseInt(br.readLine());
        if(var < 0 || var > 100) throw new MyExceptions.LogicException("range for damage is <0,100>");
        segment.setDamage(var);
        segment.update();
        System.out.println("accident record has been added");
    }
}
